#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "areas/2/custom.model.inc.h"

#include "areas/3/custom.model.inc.h"

#include "levels/castle_inside/header.h"
#include "levels/hmc/header.h"

extern u8 _castle_inside_segment_ESegmentRomStart[];
extern u8 _castle_inside_segment_ESegmentRomEnd[];

const LevelScript level_castle_inside_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _hmc_segment_7SegmentRomStart, _hmc_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _hmcSegmentRomStart, _hmcSegmentRomEnd),
LOAD_RAW(0x0E, _castle_inside_segment_ESegmentRomStart, _castle_inside_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group10_mio0SegmentRomStart, _group10_mio0SegmentRomEnd),
LOAD_RAW(12, _group10_geoSegmentRomStart, _group10_geoSegmentRomEnd),
LOAD_MIO0(6, _group15_mio0SegmentRomStart, _group15_mio0SegmentRomEnd),
LOAD_RAW(13, _group15_geoSegmentRomStart, _group15_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_HMC_WOODEN_DOOR,          wooden_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_HMC_METAL_DOOR,           metal_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_HMC_HAZY_MAZE_DOOR,       hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_HMC_METAL_PLATFORM,       hmc_geo_0005A0),
LOAD_MODEL_FROM_GEO(MODEL_HMC_METAL_ARROW_PLATFORM, hmc_geo_0005B8),
LOAD_MODEL_FROM_GEO(MODEL_HMC_ELEVATOR_PLATFORM,    hmc_geo_0005D0),
LOAD_MODEL_FROM_GEO(MODEL_HMC_ROLLING_ROCK,         hmc_geo_000548),
LOAD_MODEL_FROM_GEO(MODEL_HMC_ROCK_PIECE,           hmc_geo_000570),
LOAD_MODEL_FROM_GEO(MODEL_HMC_ROCK_SMALL_PIECE,     hmc_geo_000588),
LOAD_MODEL_FROM_GEO(MODEL_HMC_RED_GRILLS,           hmc_geo_000530),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(29,  wooden_door_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_11),
JUMP_LINK(script_func_global_16),
JUMP_LINK(local_area_castle_inside_1_),
JUMP_LINK(local_area_castle_inside_2_),
JUMP_LINK(local_area_castle_inside_3_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_castle_inside_1_[] = {
AREA(1, Geo_castle_inside_1_0x1a16bd0),
TERRAIN(col_castle_inside_1_0xe049eb0),
SET_BACKGROUND_MUSIC(0, 54),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_castle_inside_1_),
JUMP_LINK(local_warps_castle_inside_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_castle_inside_1_[] = {
OBJECT_WITH_ACTS(0, 0, 0, 4200, 0, 180, 0, 0xa0000,  bhvInstantActiveWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, 4650, 0, 0, 0, 0x19140000,  bhvWarp, 31),
OBJECT_WITH_ACTS(22, 0, 0, -1900, 0, 0, 0, 0x160000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, 1645, 0, -950, 0, -60, 0, 0x170000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, -1645, 0, -950, 0, 60, 0, 0x150000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, 0, 780, -3400, 0, 0, 0, 0x190000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, 2944, 780, -1700, 0, -61, 0, 0x1a0000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, -2944, 780, -1700, 0, 60, 0, 0x180000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(0, 0, -100, 2375, 0, 180, 0, 0x1f0000,  bhvInstantActiveWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, -1900, 0, 180, 0, 0x2a0000,  bhvLaunchStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, -1500, 0, 180, 0, 0x340000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 1645, 0, -950, 0, 120, 0, 0x2b0000,  bhvLaunchStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 1299, 0, -750, 0, 120, 0, 0x350000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, -1645, 0, -950, 0, -120, 0, 0x290000,  bhvLaunchStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, -1299, 0, -750, 0, -120, 0, 0x330000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 0, 780, -3400, 0, 180, 0, 0x2d0000,  bhvLaunchStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 0, 780, -3000, 0, 180, 0, 0x370000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 2944, 780, -1700, 0, 120, 0, 0x2e0000,  bhvLaunchStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 2598, 780, -1500, 0, 120, 0, 0x380000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, -2944, 780, -1700, 0, -120, 0, 0x2c0000,  bhvLaunchStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, -2598, 780, -1500, 0, -120, 0, 0x360000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, 450, 0, 0, 0, 0xf3c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, 900, 0, 0, 0, 0x3d0000,  bhvInstantActiveWarp, 31),
OBJECT_WITH_ACTS(38, -74, 0, 735, 0, 0, 0, 0x14000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, 74, 0, 735, 0, 180, 0, 0x14000000,  bhvDoor, 31),
RETURN()
};

const LevelScript local_warps_castle_inside_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(20, 16, 1, 50, 0),
WARP_NODE(21, 9, 1, 10, 0),
WARP_NODE(22, 24, 1, 10, 0),
WARP_NODE(23, 12, 1, 10, 0),
WARP_NODE(24, 5, 1, 10, 0),
WARP_NODE(25, 4, 1, 10, 0),
WARP_NODE(26, 7, 1, 10, 0),
WARP_NODE(31, 6, 1, 0, 0),
WARP_NODE(0, 6, 1, 0, 0),
WARP_NODE(41, 6, 1, 0, 0),
WARP_NODE(42, 6, 1, 0, 0),
WARP_NODE(43, 6, 1, 0, 0),
WARP_NODE(44, 6, 1, 0, 0),
WARP_NODE(45, 6, 1, 0, 0),
WARP_NODE(46, 6, 1, 0, 0),
WARP_NODE(51, 6, 1, 0, 0),
WARP_NODE(52, 6, 1, 0, 0),
WARP_NODE(53, 6, 1, 0, 0),
WARP_NODE(54, 6, 1, 0, 0),
WARP_NODE(55, 6, 1, 0, 0),
WARP_NODE(56, 6, 1, 0, 0),
WARP_NODE(60, 6, 2, 10, 0),
WARP_NODE(61, 6, 1, 0, 0),
WARP_NODE(240, 6, 1, 50, 0),
WARP_NODE(241, 16, 1, 1, 0),
RETURN()
};

const LevelScript local_area_castle_inside_2_[] = {
AREA(2, Geo_castle_inside_2_0x1a16ab0),
TERRAIN(col_castle_inside_2_0xe050000),
SET_BACKGROUND_MUSIC(0, 54),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_castle_inside_2_),
JUMP_LINK(local_warps_castle_inside_2_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_castle_inside_2_[] = {
OBJECT_WITH_ACTS(0, 0, 0, 900, 0, 0, 0, 0xa0000,  bhvInstantActiveWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, 450, 0, 0, 0, 0xf0b0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, -450, 0, 0, 0, 0xf140000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, -1200, 0, 180, 0, 0x3c0000,  bhvInstantActiveWarp, 31),
OBJECT_WITH_ACTS(0, -3507, 813, 2025, 0, -60, 0, 0x19150000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 3507, 813, 2025, 0, 60, 0, 0x19160000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 3507, 813, -2025, 0, 120, 0, 0x19170000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -3507, 813, -2025, 0, 240, 0, 0x19180000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 1300, 813, 2800, 0, 90, 0, 0x19190000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -1300, 813, -2800, 0, -90, 0, 0x191a0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -3377, 813, 1950, 0, -60, 0, 0x290000,  bhvPaintingStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, -3377, 813, 1950, 0, -60, 0, 0x330000,  bhvPaintingDeathWarp, 31),
OBJECT_WITH_ACTS(0, 3377, 813, 1950, 0, 60, 0, 0x2a0000,  bhvPaintingStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 3377, 813, 1950, 0, 60, 0, 0x340000,  bhvPaintingDeathWarp, 31),
OBJECT_WITH_ACTS(0, 3377, 813, -1950, 0, 120, 0, 0x2b0000,  bhvPaintingStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 3377, 813, -1950, 0, 120, 0, 0x350000,  bhvPaintingDeathWarp, 31),
OBJECT_WITH_ACTS(0, -3377, 813, -1950, 0, 240, 0, 0x2c0000,  bhvPaintingStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, -3377, 813, -1950, 0, 240, 0, 0x360000,  bhvPaintingDeathWarp, 31),
OBJECT_WITH_ACTS(0, 1150, 813, 2800, 0, 90, 0, 0x2d0000,  bhvPaintingStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 1150, 813, 2800, 0, 90, 0, 0x370000,  bhvPaintingDeathWarp, 31),
OBJECT_WITH_ACTS(0, -1150, 813, -2800, 0, -90, 0, 0x2e0000,  bhvPaintingStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, -1150, 813, -2800, 0, -90, 0, 0x380000,  bhvPaintingDeathWarp, 31),
OBJECT_WITH_ACTS(0, -3507, 563, 2025, 0, -60, 0, 0x19150000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 3507, 563, 2025, 0, 60, 0, 0x19160000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 3507, 563, -2025, 0, 120, 0, 0x19170000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -3507, 563, -2025, 0, 240, 0, 0x19180000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 1300, 563, 2800, 0, 90, 0, 0x19190000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -1300, 563, -2800, 0, -90, 0, 0x191a0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -1300, 1063, -2800, 0, -90, 0, 0x191a0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 1300, 1063, 2800, 0, 90, 0, 0x19190000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -3507, 1063, -2025, 0, 240, 0, 0x19180000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 3507, 1063, -2025, 0, 120, 0, 0x19170000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 3507, 1063, 2025, 0, 60, 0, 0x19160000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -3507, 1063, 2025, 0, -60, 0, 0x19150000,  bhvWarp, 31),
OBJECT_WITH_ACTS(38, -75, 0, 735, 0, 0, 0, 0x14000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, 75, 0, 735, 0, 180, 0, 0x14000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, -75, 0, -735, 0, 0, 0, 0x32000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, 75, 0, -735, 0, 180, 0, 0x32000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(137, -450, 1200, -2090, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -374, 1189, 2993, 0, 0, 0, 0x10000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(212, -661, -425, 2326, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(34, 0, 0, 1800, 0, 180, 0, 0x1e000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(34, 0, 0, -1800, 0, 0, 0, 0x28000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, 1558, 0, 900, 0, 240, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, -1558, 0, 900, 0, 120, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, -1558, 0, -900, 0, 60, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, 1558, 0, -900, 0, 300, 0, 0x0,  bhvDoor, 31),
RETURN()
};

const LevelScript local_warps_castle_inside_2_[] = {
WARP_NODE(10, 9, 2, 0, 0),
WARP_NODE(11, 6, 1, 61, 0),
WARP_NODE(20, 6, 3, 10, 0),
WARP_NODE(21, 22, 1, 10, 0),
WARP_NODE(22, 8, 1, 10, 0),
WARP_NODE(23, 23, 1, 10, 0),
WARP_NODE(24, 10, 1, 10, 0),
WARP_NODE(25, 28, 1, 10, 0),
WARP_NODE(26, 18, 1, 10, 0),
WARP_NODE(41, 6, 2, 0, 0),
WARP_NODE(42, 6, 2, 0, 0),
WARP_NODE(43, 6, 2, 0, 0),
WARP_NODE(44, 6, 2, 0, 0),
WARP_NODE(45, 6, 2, 0, 0),
WARP_NODE(46, 6, 2, 0, 0),
WARP_NODE(51, 6, 2, 0, 0),
WARP_NODE(52, 6, 2, 0, 0),
WARP_NODE(53, 6, 2, 0, 0),
WARP_NODE(54, 6, 2, 0, 0),
WARP_NODE(55, 6, 2, 0, 0),
WARP_NODE(56, 6, 2, 0, 0),
WARP_NODE(60, 6, 2, 0, 0),
WARP_NODE(240, 6, 1, 50, 0),
WARP_NODE(241, 16, 1, 1, 0),
RETURN()
};

const LevelScript local_area_castle_inside_3_[] = {
AREA(3, Geo_castle_inside_3_0x1a16990),
TERRAIN(col_castle_inside_3_0xe0534a0),
SET_BACKGROUND_MUSIC(0, 54),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_castle_inside_3_),
JUMP_LINK(local_warps_castle_inside_3_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_castle_inside_3_[] = {
OBJECT_WITH_ACTS(0, 0, 0, -900, 0, 180, 0, 0xa0000,  bhvInstantActiveWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, -450, 0, 0, 0, 0xf140000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, 2500, 0, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 1097, 2500, 0, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 549, 2500, 950, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 549, 2500, -950, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -549, 2500, -950, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -549, 2500, 950, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -1097, 2500, 0, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -549, 2500, -317, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -549, 2500, 317, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 549, 2500, 317, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 549, 2500, -317, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, 2500, 633, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, 2500, -633, 0, 0, 0, 0x373c0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, 2000, 600, 0, 0, 0, 0x3d0000,  bhvAirborneWarp, 31),
OBJECT_WITH_ACTS(201, 0, 822, 0, 0, 0, 0, 0x0,  bhvCannonClosed, 31),
OBJECT_WITH_ACTS(195, 0, 770, -550, 0, 0, 0, 0x0,  bhvBobombBuddyOpensCannon, 31),
OBJECT_WITH_ACTS(0, 0, 0, 0, 0, 0, 0, 0x5a003228,  Bhv_Custom_0x130058b0, 31),
OBJECT_WITH_ACTS(0, -3074, 520, -1775, 0, 240, 0, 0xf150000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 3000, 920, -1732, 0, 120, 0, 0xf160000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 3000, 770, -1732, 0, 120, 0, 0xf160000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 3000, 1070, -1732, 0, 120, 0, 0xf160000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -2698, 520, 1557, 0, 300, 0, 0xf170000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 2630, 520, 1345, 0, 330, 0, 0xf180000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, 520, 3150, 0, 0, 0, 0xf190000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, 520, -3550, 0, 180, 0, 0xf1a0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, 450, 0, 180, 0, 0xf1b0000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, -2555, 1544, -1475, 0, 240, 0, 0xf290000,  bhvAirborneStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, -2555, 520, -1475, 0, 240, 0, 0xf330000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 2907, 920, -1679, 0, 120, 0, 0xf2a0000,  bhvPaintingStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 2907, 920, -1679, 0, 120, 0, 0xf340000,  bhvPaintingDeathWarp, 31),
OBJECT_WITH_ACTS(0, -2148, 1544, 1240, 0, 300, 0, 0xf2b0000,  bhvAirborneStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, -2148, 520, 1240, 0, 300, 0, 0xf350000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 2930, 1544, 825, 0, 330, 0, 0xf2c0000,  bhvAirborneStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 2930, 520, 825, 0, 330, 0, 0xf360000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 0, 1544, 2550, 0, 0, 0, 0xf2d0000,  bhvAirborneStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 0, 520, 2550, 0, 0, 0, 0xf370000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 0, 1544, -2950, 0, 180, 0, 0xf2e0000,  bhvAirborneStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 0, 520, -2950, 0, 180, 0, 0xf380000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 0, 512, 1050, 0, 180, 0, 0xf2f0000,  bhvAirborneStarCollectWarp, 31),
OBJECT_WITH_ACTS(0, 0, 0, 1050, 0, 180, 0, 0xf390000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(38, -75, 0, -735, 0, 0, 0, 0x32000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, 75, 0, -735, 0, 180, 0, 0x32000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, 0, 520, -3265, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(38, -2827, 520, -1632, 0, 60, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(34, -2451, 520, 1415, 0, 120, 0, 0x3c000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(34, 0, 520, 2865, 0, 180, 0, 0x50000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(34, 2772, 520, 1098, 0, 150, 0, 0x46000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(34, 0, 0, 735, 0, 0, 0, 0x64000000,  bhvDoor, 31),
RETURN()
};

const LevelScript local_warps_castle_inside_3_[] = {
WARP_NODE(10, 9, 3, 0, 0),
WARP_NODE(20, 6, 2, 60, 0),
WARP_NODE(60, 16, 1, 52, 0),
WARP_NODE(61, 6, 3, 0, 0),
WARP_NODE(21, 11, 1, 10, 0),
WARP_NODE(22, 36, 1, 10, 0),
WARP_NODE(23, 13, 1, 10, 0),
WARP_NODE(24, 14, 1, 10, 0),
WARP_NODE(25, 15, 1, 10, 0),
WARP_NODE(26, 29, 1, 10, 0),
WARP_NODE(27, 20, 1, 10, 0),
WARP_NODE(41, 6, 3, 0, 0),
WARP_NODE(42, 6, 3, 0, 0),
WARP_NODE(43, 6, 3, 0, 0),
WARP_NODE(44, 6, 3, 0, 0),
WARP_NODE(45, 6, 3, 0, 0),
WARP_NODE(46, 6, 3, 0, 0),
WARP_NODE(47, 6, 3, 0, 0),
WARP_NODE(51, 6, 3, 0, 0),
WARP_NODE(52, 6, 3, 0, 0),
WARP_NODE(53, 6, 3, 0, 0),
WARP_NODE(54, 6, 3, 0, 0),
WARP_NODE(55, 6, 3, 0, 0),
WARP_NODE(56, 6, 3, 0, 0),
WARP_NODE(57, 6, 3, 0, 0),
WARP_NODE(240, 6, 1, 50, 0),
WARP_NODE(241, 16, 1, 1, 0),
RETURN()
};
